/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.executor;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.io.PrintStream;
import java.util.HashMap;

public class PrintWorkExecutor
implements IWorkExecutor {
    private PrintStream stream;
    private HashMap<String, Boolean> map = new HashMap();

    public PrintWorkExecutor(String[] succeed, String[] fail, PrintStream stream) {
        this.stream = stream;
        this.addPrimitives(succeed, Boolean.TRUE);
        this.addPrimitives(fail, Boolean.FALSE);
    }

    public synchronized void addPrimitives(String[] primitives, Boolean value) {
        for (String primtive : primitives) {
            if (this.map.put(primtive, value) == null) continue;
            throw new IllegalArgumentException("Primitive \"" + primtive + "\" has already been specified.");
        }
    }

    public PrintWorkExecutor(String[] succeed, String[] fail) {
        this(succeed, fail, System.out);
    }

    private Object executePrimitive(String primitive, VariableContext ctx) {
        Boolean value = this.map.get(primitive);
        if (value == null) {
            throw new IllegalArgumentException("Primitive \"" + primitive + "\" is not specified in the worker.");
        }
        this.stream.println(this.getClass().getSimpleName() + ": execute \"" + primitive + "\"" + ctx.toString() + " -> " + value);
        return value;
    }

    @Override
    public synchronized Object executeSense(String primitive, VariableContext ctx) {
        return this.executePrimitive(primitive, ctx);
    }

    @Override
    public synchronized ActionResult executeAction(String primitive, VariableContext ctx) {
        Object result = this.executePrimitive(primitive, ctx);
        if (result instanceof ActionResult) {
            return (ActionResult)((Object)result);
        }
        return ActionResult.FINISHED;
    }
}

