/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.SenseResult;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import java.util.ArrayList;

public final class ElementStackTrace
extends ArrayList<StackElement> {
    public synchronized void printStackTrace() {
        System.out.println("ElementStackTrace:");
        for (StackElement element : this) {
            System.out.println(element);
        }
    }

    public void push(StackElement element) {
        this.add(element);
    }

    public StackElement pop() {
        if (this.size() == 0) {
            return null;
        }
        return (StackElement)this.remove(this.size() - 1);
    }

    public StackElement peek() {
        if (this.size() == 0) {
            return null;
        }
        return (StackElement)this.get(this.size() - 1);
    }

    public void removeAllElements() {
        this.clear();
    }

    public void cutDownToIncluding(ElementExecutor executor) {
        if (executor == null) {
            this.removeAllElements();
            return;
        }
        while (this.size() != 0 && this.peek().getExecutor() != executor) {
            this.pop();
        }
        if (this.size() > 0) {
            this.pop();
        }
    }

    public void cutDownToExcluding(ElementExecutor executor) {
        if (executor == null) {
            this.removeAllElements();
            return;
        }
        while (this.size() != 0 && this.peek().getExecutor() != executor) {
            this.pop();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (StackElement element : this) {
            sb.append('/');
            String type = element.getTypeName();
            sb.append(type);
            sb.append(':');
            sb.append(element.name);
            TriggerResult triggerResult = element.getTriggerResults();
            if (triggerResult == null) continue;
            for (SenseResult senseResult : element.getTriggerResults()) {
                sb.append('[');
                sb.append(senseResult.name);
                sb.append(':');
                sb.append(senseResult.wasSuccessful() ? (char)'1' : '0');
                sb.append(']');
            }
        }
        return sb.toString();
    }
}

