package cz.cuni.amis.pogamut.sposh.engine;

import java.util.logging.Logger;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Adopt;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;

/**
 * Executor for CE. 
 * @author Honza
 */
class CEExecutor extends AbstractExecutor implements ElementExecutor {
    private PoshPlan plan;
    private PrimitiveCall actionCall;
    private String name;
    private SenseListExecutor<CompetenceElement> trigger;
    private int retries = 0;
    private int maxRetries;
    private TriggerResult result;
    
    /**
     * Create competence executor.
     * @param plan plan that will be used to resolve primitives
     * @param ce competence element that is going to be executed
     * @param ctx variable context of competence element
     * @param log logger to record actions of this executor, can be null
     */
    CEExecutor(PoshPlan plan, CompetenceElement ce, VariableContext ctx, Logger log) {
        super(ctx, log);

        name = ce.getName();
        trigger = new SenseListExecutor<CompetenceElement>(ce.getTrigger(), ctx, log);
        maxRetries = ce.getRetries();
        this.plan = plan;
        this.actionCall = ce.getAction().getActionCall();
    }

    /**
     * FIXME: I should probably make single method and join methods in CEExecutor, APExecutor and DEExecutor
     * @param plan
     * @param actionCall
     * @return
     */
    private StackElement createActionExecutor(PoshPlan plan, PrimitiveCall actionCall) {
    	return getElement(plan, actionCall, 
				  FireResult.Type.SURFACE_CONTINUE, 
				  FireResult.Type.SURFACE,
				  FireResult.Type.SURFACE,
				  FireResult.Type.FAILED
	              
			   ); 
    }

    /**
     * Can this executor be executed? Are all preconditions (triggers and 
     * retries) OK?
     * @param workExecuter
     * @return
     */
    TriggerResult isReady(IWorkExecutor workExecuter) {
        fine("isReady? " + retries + "/" + maxRetries);
        if (maxRetries == CompetenceElement.INFINITE_RETRIES || retries < maxRetries) {
            result = trigger.fire(workExecuter, true);
        } else {
            result = new TriggerResult(false);
        }
        return result;
    }

    /**
     * How should this behave:
     *  - if called from above, return new FOLLOW element for the action
     *  - if the action was already finished, return
     * @param workExecuter
     * @return
     */
    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        if (actionCalled) {
            actionCalled = false;
            return new FireResult(FireResult.Type.SURFACE);
        }

        retries++;
        actionCalled = true;
        return new FireResult(FireResult.Type.FOLLOW, createActionExecutor(plan, actionCall));
    }

    private boolean actionCalled = false;

    /**
     * @return Get name of this CE
     */
    String getName() {
        return name;
    }

    @Override
    public TriggerResult getTriggerResult() {
        return result;
    }
}
