/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceTest;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PoshDummyElementTest {
    private final String elementPrefix = "sense";
    int numTestElements = 10;
    int numTest = 100;
    List<Sense> elements;
    PoshDummyElementImpl<Sense> instance;

    @Before
    public void setUp() {
        this.elements = new LinkedList<Sense>();
        for (int i = 0; i < this.numTestElements; ++i) {
            this.elements.add(new Sense("sense" + i));
        }
        this.instance = new PoshDummyElementImpl<Sense>("test-posh-dummy-element", this.elements);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testPattern() {
        String pattern = "([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*";
        String[] ok = new String[]{"succeed", "cz.cuni.pogamut.Fail", "prime3", "A-B.Nya12", "www.kernel.com", "welcome-home.Kill_All_Humans.Was-there-2"};
        String[] crash = new String[]{" succeed", "succ eed", "123ahoj", "Nya.123.ahoj", "Baka(Evil)", "Hello*World", "Durable/Goods", "red@envelope", ".hu", "one..two"};
        for (String test : ok) {
            Assert.assertTrue((String)test, (boolean)test.matches(pattern));
        }
        for (String test : crash) {
            Assert.assertFalse((String)test, (boolean)test.matches(pattern));
        }
    }

    @Test(expected=NoSuchElementException.class)
    public void testMoveNodeWrongNode() {
        System.out.println("moveNodeInList - wrong node");
        this.instance.moveNodeInList(this.elements, (PoshElement)new Sense(PoshDummyElement.getUnusedName((String)"sense", this.instance.getChildDataNodes())), 1);
    }

    @Test
    public void testMoveChildPos() {
        System.out.println("moveChild - position");
        for (int pos = 0; pos < this.elements.size(); ++pos) {
            int relPos;
            int j;
            PoshElement element = (PoshElement)this.instance.getChildDataNodes().get(pos);
            for (j = -20; j < 0; ++j) {
                relPos = -pos + j;
                Assert.assertFalse((String)("Relative pos " + relPos + " from " + this.elements.indexOf(element) + " 0.." + (this.elements.size() - 1)), (boolean)this.instance.moveNodeInList(this.elements, element, relPos));
            }
            for (j = 0; j < this.elements.size(); ++j) {
                relPos = -pos + j;
                Assert.assertTrue((String)("Relative pos " + relPos + " from " + this.elements.indexOf(element) + " 0.." + (this.elements.size() - 1)), (boolean)this.instance.moveNodeInList(this.elements, element, relPos));
                int newPos = pos + relPos;
                Assert.assertTrue((this.elements.get(newPos) == element ? 1 : 0) != 0);
                if (newPos != pos) {
                    Assert.assertTrue((this.elements.get(pos) != element ? 1 : 0) != 0);
                }
                this.instance.moveNodeInList(this.elements, element, -relPos);
            }
            for (j = this.elements.size(); j < this.elements.size() + 20; ++j) {
                relPos = -pos + j;
                Assert.assertFalse((String)("Relative pos " + relPos + " from " + this.elements.indexOf(element) + " 0.." + (this.elements.size() - 1)), (boolean)this.instance.moveNodeInList(this.elements, element, relPos));
            }
        }
    }

    @Test
    public void testMoveChildListener() {
        System.out.println("moveChild - positive bust position");
        for (int i = 0; i < this.numTest; ++i) {
            CompetenceTest.DummyListener instanceListener = new CompetenceTest.DummyListener();
            this.instance.addElementListener(instanceListener);
            int startPos = new Random(48879L).nextInt(this.instance.getChildDataNodes().size());
            int endPos = new Random(48879L).nextInt(this.instance.getChildDataNodes().size());
            PoshElement element = (PoshElement)this.instance.getChildDataNodes().get(startPos);
            this.instance.moveNodeInList(this.elements, element, endPos - startPos);
            Assert.assertTrue((instanceListener.lastEvent == PoshTreeEvent.CHILD_NODE_MOVED && instanceListener.lastChild == element ? 1 : 0) != 0);
            Assert.assertTrue((this.elements.get(endPos) == element ? 1 : 0) != 0);
            this.instance.removeElementListener(instanceListener);
        }
    }

    @Test
    public void testIsUsedName() {
        System.out.println("isUsedName");
        for (int i = 0; i < this.numTestElements; ++i) {
            Assert.assertTrue((boolean)PoshDummyElement.isUsedName((String)("sense" + i), this.elements));
            Assert.assertFalse((boolean)PoshDummyElement.isUsedName((String)("sense" + (i + this.numTestElements)), this.elements));
        }
        Assert.assertFalse((boolean)PoshDummyElement.isUsedName((String)"World-is-doomed", this.elements));
        Assert.assertFalse((boolean)PoshDummyElement.isUsedName((String)"walk-ahead", this.elements));
    }

    @Test
    public void testGetUnusedName() {
        System.out.println("getUnusedName");
        System.out.print("Unused names:");
        for (int i = 0; i < this.numTest; ++i) {
            String unusedName = PoshDummyElement.getUnusedName((String)"sense", this.elements);
            System.out.print(" " + unusedName);
            Assert.assertFalse((boolean)PoshDummyElement.isUsedName((String)unusedName, this.elements));
            this.elements.add(new Sense(unusedName));
        }
        System.out.println();
    }

    public static class PoshDummyElementImpl<T extends PoshElement>
    extends PoshDummyElement {
        private final String name;
        private final List<T> elements;

        PoshDummyElementImpl(String name, List<T> elements) {
            this.name = name;
            this.elements = Collections.unmodifiableList(elements);
        }

        public DataFlavor getDataFlavor() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List<T> getChildDataNodes() {
            return this.elements;
        }

        public String getName() {
            return this.name;
        }

        public void addChildDataNode(PoshElement newChild) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean moveChild(PoshElement child, int relativePosition) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void neutralizeChild(PoshElement childNode) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

