package cz.cuni.amis.pogamut.sposh.elements;

import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Triggers is a list of PoshSenses.
 *
 * If all sense of triggers are fulfilled, some action can
 * be executed (in competence, drive ...)
 *
 * @author Honza
 */
public class Triggers extends PoshDummyElement {

    private ElementList<Sense> _sense_list;

    /**
     * Create a new Triggers with one sense.
     *
     * @param defaultTrigger
     */
    public Triggers(Sense defaultTrigger) {
        _sense_list = new ElementList<Sense>();
        this.addTrigger(defaultTrigger);
    }

    /**
     * Triggers can have an empty list of senses. Not sure what to do with it, but whatever
     */
    public Triggers() {
        _sense_list = new ElementList<Sense>();
    }

    public Triggers(ElementList<Sense> sense_list) {
        _sense_list = new ElementList<Sense>();

        for (Sense sense : sense_list) {
            addTrigger(sense);
        }
    }

    /**
     * Add a trigger to the triggers (add, set parent, emit)
     * @param trigger
     */
    public void addTrigger(Sense sense) {
        sense.setParent(this);
        _sense_list.add(sense);

        emitChildNode(sense);
    }

    /**
     * If there is only one sense in {@link Triggers} named either "fail" 
     * or "succeed", replace it with passed sense.
     * <p>
     * Otherwise behave same as {Triggers.addTrigger()}.
     * @param sense Sense to add to trigger
     */
    public void addUserTrigger(Sense sense) {
        if (_sense_list.size() == 1 && ("succeed".equals(_sense_list.get(0).getSenseName()) || "fail".equals(_sense_list.get(0).getSenseName()))) {
            _sense_list.get(0).changeTo(sense);
        } else {
            addTrigger(sense);
        }
    }

    @Override
    public String toString() {
        return _sense_list.toString();
    }

    @Override
    public List<PoshElement> getChildDataNodes() {
        return new ArrayList<PoshElement>(_sense_list);
    }

    @Override
    public String getDisplayName() {
        return "Triggers";
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        return moveNodeInList(this._sense_list, child, relativePosition);
    }
    public static final DataFlavor dataFlavor = new DataFlavor(Triggers.class, "triggers");

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement newChild) {
        if (newChild instanceof Sense) {
            this.addTrigger((Sense) newChild);
        } else {
            throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
        }
    }

    @Override
    public void neutralizeChild(PoshElement childNode) {
        if (this._sense_list.contains(childNode)) {
            if (this._sense_list.size() <= 1) {
                this.addTrigger(new Sense("fail"));
            }
            this._sense_list.remove(childNode);
            childNode.remove();
        }
    }

    /**
     * Get unmodifiable list of senses in this trigger
     */
    public List<Sense> getSenses() {
        return Collections.unmodifiableList(_sense_list);
    }
}
