package cz.cuni.amis.pogamut.sposh.elements;

import java.util.LinkedList;
import java.util.List;

/**
 * This is class used as mediator between PoshElement and
 * DataNodes of POSH elements. Some common functions are implemented here.
 * 
 * @author Honza
 */
public abstract class PoshDummyElement extends PoshElement {
    /**
     * Static list used when element doesn't have any children (like sense ).
     */
    protected static List<PoshElement> emptyChildrenList = new LinkedList<PoshElement>();

    /**
     * Regular pattern, only text that maches this pattern can be
     * a name of the POSH element.
     * <p>
     * Pattern: [_a-zA-Z][_\\-a-zA-Z0-9]*
     */
    final static protected String IDENT_PATTERN = "[_a-zA-Z][_\\-a-zA-Z0-9]*";

    /**
     * Helping function for moving nodes in the POSH tree.
     * Find <code>child</code> in <code>collection</code> and move it
     * up or down according to <code>relativePosition</code>.
     *
     * If destination position if out of bounds or <code>child</code>
     * is not in <code>collection</code>, don't do anything
     *
     * If <code>child</code> was moved, emit child moved event.
     *
     * @return return true if child was actually moved, else false
     */
    protected boolean moveNodeInList(List collection, PoshElement child, int relativePosition) {
/*        System.out.println("MoveNodein collection " + child.getDisplayName() + ", " + child.getClass().getSimpleName() + " by " + relativePosition);
        for (Object o : collection) {
            PoshElement n = (PoshElement) o;
            System.out.println("  DN siblings " + n.getDisplayName());
        }
*/
        // find index of child
        int childIndex = -1;
        for (int index = 0; index < collection.size(); index++) {
            if (collection.get(index) == child) {
                childIndex = index;
            }
        }
        if (childIndex == -1) {
            throw new RuntimeException("Child " + child + "is not in collection.");
        }
        int bustPos = childIndex + relativePosition;
        if (bustPos < 0 || bustPos >= collection.size()) {
            return false;
        }

        collection.add(bustPos, child);

        // remove former child
        if (relativePosition > 0) {
            collection.remove(childIndex);
        } else {
            collection.remove(childIndex + 1);
        }

        /*		System.out.println("-----------");
        for (Object o : collection) {
        PoshElement n = (PoshElement) o;
        System.out.println("  DN siblings " + n.getDisplayName());
        }
        System.out.println("-----------");
         */

        this.emitChildMove(child, relativePosition);

        return true;
    }
}
