package cz.cuni.amis.pogamut.sposh.elements;

import java.util.ArrayList;
import java.util.List;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;
import java.util.LinkedList;

/**
 * Competence element is basically list of CompetenceAtoms. Very rarely used,
 * but here it is anyway.
 * <p>
 * <pre>( 
 *   (stuck (trigger ((is-stuck))) avoid)  &lt;- CompetenceElement
 *   (pickup (trigger ((see-item))) pickup-item) &lt;- CompetenceElement
 * )</pre> 
 * 
 * @author Honza Havlicek
 */
public class CompetencePriorityElement extends PoshDummyElement {

	protected LinkedList<CompetenceElement> competenceElements = new LinkedList<CompetenceElement>();

	/**
	 * Constructor for parser
	 */
	CompetencePriorityElement() {
	}

	/**
	 * Create new CompetencePriorityElement that has one default CompetenceElement inside
	 * named <tt>atomName</tt>.
	 * 
	 * @param atomName
	 */
	public CompetencePriorityElement(CompetenceElement element) {
		element.setParent(this);
		competenceElements.add(element);
	}

	/**
	 * Add another CompetenceElement to this CompetencePriorityElement and emit new children.
	 * 
	 * @param competenceAtom
	 */
	public void addCompetenceElement(CompetenceElement element) {
		element.setParent(this);
		competenceElements.add(element);

		emitChildNode(element);
	}

        /**
         * Get unmodifiable list of CE in this CPE.
         * @return list of elements contained in this CPE
         */
        public List<CompetenceElement> getElements() {
            return Collections.unmodifiableList(this.competenceElements);
        }

	@Override
	public String toString() {
		String res = "";
		for (CompetenceElement atom : competenceElements) {
			res += " " + atom.toString();
		}

		return res;
	}

		
	@Override
	public List<PoshElement> getChildDataNodes() {
		return new ArrayList<PoshElement>(competenceElements);
	}

	@Override
	public String getDisplayName() {
		if (competenceElements.size() > 0) {
			return "CompElem:" + competenceElements.get(0).getDisplayName();
		}
		return "Priority Competence";
	}
	
	/**
	 * Move child in the structure and notify listening widgets.
	 * 
	 * @param child
	 * @param relativePosition numer of positions up/down
	 * @return success
	 */
	@Override
	public boolean moveChild(PoshElement child, int relativePosition) {
		return moveNodeInList(competenceElements, child, relativePosition);
	}

	public static final DataFlavor dataFlavor = new DataFlavor(CompetenceElement.class, "competence-atom");
	
	@Override
	public DataFlavor getDataFlavor() {
		return dataFlavor;
	}

	@Override
	public void addChildDataNode(PoshElement newChild) {
		if (newChild instanceof CompetenceElement) {
			this.addCompetenceElement((CompetenceElement) newChild);
		} else {
			throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
		}
	}

	@Override
	public void neutralizeChild(PoshElement childNode) {
		if (this.competenceElements.contains(childNode)) {
			if (this.competenceElements.size() <= 1) {
				this.addCompetenceElement(new CompetenceElement("comp", new Sense("fail"), "do_nothing", null));
			}
			this.competenceElements.remove(childNode);
			childNode.remove();
		}
	}
	
}
