package cz.cuni.amis.pogamut.sposh.elements;

import java.util.ArrayList;

/**
 * List of PoshActs, helping structure used in other parts of tree.
 * 
 * XXX: for now add is empty
 * @author Honza
 */
public class ElementList<T> extends ArrayList<T> {

    /**
     * Create an empty ElementList.
     * @param list
     */
    public ElementList() {
    }

    /**
     * Create an ElementList with one element in it.
     * @param list
     */
    public ElementList(T element) {
        this.add(element);
    }


    /**
     * Create an ElementList with elements from passed array.
     * @param list list of elements that will be in the ElementList after creation.
     */
    public ElementList(T[] list) {
        for (T element : list) {
            this.add(element);
        }
    }

    @Override
    public String toString() {
        String ret = "(";
        boolean firstFlag = true;

        for (T act : this) {
            if (firstFlag) {
                firstFlag = false;
                ret += act.toString();
            } else {
                ret += " " + act.toString();
            }
        }

        return ret + ")";
    }
}
