package cz.cuni.amis.pogamut.sposh.elements;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;

/**
 * List of DriveElements. In theory all drivelements should be executed paralelly. 
 * Almost never used.
 * <p>
 * <pre>
 * (
 *   (follow (trigger((see-player))) follow-player)) &lt;- DriveElement
 *   (fire (trigger((see-player))) fire-at-enemy)  &lt;- DriveElement
 * )
 * </pre>
 * 
 * @author Honza
 */
public class DrivePriorityElement extends PoshDummyElement {

    protected List<DriveElement> _driveElements = new LinkedList<DriveElement>();
    protected List<DriveElement> driveElementsUn = Collections.unmodifiableList(_driveElements);

    public DrivePriorityElement(DriveElement element) {
        element.setParent(this);

        _driveElements.add(element);
    }

    public void addDriveElement(DriveElement driveElement) {
        driveElement.setParent(this);
        _driveElements.add(driveElement);
        emitChildNode(driveElement);
    }

    @Override
    public String toString() {
        String res = "";
        for (DriveElement element : _driveElements) {
            res += element.toString() + " ";
        }
        return res;
    }

    @Override
    public List<PoshElement> getChildDataNodes() {
        return new ArrayList<PoshElement>(_driveElements);
    }

    @Override
    public String getDisplayName() {
        return "Priority drive";
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        return moveNodeInList(this._driveElements, child, relativePosition);
    }
    public static final DataFlavor dataFlavor = new DataFlavor(DrivePriorityElement.class, "drive");

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement newChild) {
        if (newChild instanceof DriveElement) {
            this.addDriveElement((DriveElement) newChild);
        } else {
            throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
        }
    }

    @Override
    public void neutralizeChild(PoshElement childNode) {
        if (this._driveElements.contains(childNode)) {
            if (this._driveElements.size() <= 1) {
                this.addDriveElement(new DriveElement("drive_element", new Triggers(new Sense("fail")), "do_nothing", null));
            }
            this._driveElements.remove(childNode);
            childNode.remove();
        }
    }

    /**
     * Get unmodifiable list of DriveElement s
     */
    public List<DriveElement> getDriveElements() {
        return driveElementsUn;
    }


}
