/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.Result;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ValueTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private void testValueFail(String value, Class clazz) {
        if (clazz.isInstance(Result.parseValue((String)value))) {
            Assert.fail((String)("Value created from string \"" + value + "\" is " + clazz.getSimpleName() + ", but shouldn't be."));
        }
    }

    private void testValueSucceed(String value, Class clazz) {
        Object result = Result.parseValue((String)value);
        if (!clazz.isInstance(result)) {
            Assert.fail((String)("Value created from string \"" + value + "\" is not " + clazz + " but " + result.getClass()));
        }
    }

    @Test
    public void testCreateValue() {
        System.out.println("createValue");
        if (Result.parseValue((String)"nil") != null) {
            Assert.fail((String)"nil should be translated to null");
        }
        this.testValueSucceed("true", Boolean.class);
        this.testValueSucceed("True", Boolean.class);
        this.testValueFail("TRue", Boolean.class);
        this.testValueSucceed("False", Boolean.class);
        this.testValueSucceed("false", Boolean.class);
        this.testValueFail("falSe", Boolean.class);
        this.testValueSucceed("-12", Integer.class);
        this.testValueSucceed("12", Integer.class);
        this.testValueFail("12.0", Integer.class);
        this.testValueFail("12.0d", Integer.class);
        this.testValueSucceed("99.0", Double.class);
        this.testValueSucceed("-345.75", Double.class);
        this.testValueSucceed(".54", Double.class);
        this.testValueSucceed("-.88", Double.class);
        this.testValueFail(".8.4", Double.class);
    }
}

