/*
 * Decompiled with CFR 0.152.
 */
package JSHOP2;

import JSHOP2.CompileTimeObject;
import JSHOP2.Term;
import JSHOP2.TermList;
import java.util.Iterator;
import java.util.LinkedList;

public class List
extends CompileTimeObject {
    private Term head;
    private Term tail;

    public List(Term headIn, Term tailIn) {
        this.head = headIn;
        this.tail = tailIn;
    }

    public List append(Term t) {
        List l = this;
        while (!l.tail.isNil()) {
            l = l.getRest();
        }
        l.tail = t;
        return this;
    }

    public List bindList(Term[] binding) {
        return new List(this.head.bind(binding), this.tail.bind(binding));
    }

    public boolean equals(List t) {
        return this.head.equals(t.head) && this.tail.equals(t.tail);
    }

    public boolean findUnifierList(List l, Term[] binding) {
        if (l == null) {
            return false;
        }
        return this.head.findUnifier(l.head, binding) && this.tail.findUnifier(l.tail, binding);
    }

    public Term getHead() {
        return this.head;
    }

    public List getRest() {
        return ((TermList)this.tail).getList();
    }

    public Term getTail() {
        return this.tail;
    }

    public boolean isGroundList() {
        return this.head.isGround() && this.tail.isGround();
    }

    public static List MakeList(LinkedList listIn) {
        List retVal = null;
        Iterator e = listIn.iterator();
        while (e.hasNext()) {
            retVal = new List((Term)e.next(), new TermList(retVal));
        }
        return retVal;
    }

    public void print() {
        System.out.println("(" + this + ")");
    }

    public String toCode() {
        return "new List(" + this.head.toCode() + ", " + this.tail.toCode() + ")";
    }

    public String toString() {
        if (this.tail instanceof TermList) {
            if (this.tail.isNil()) {
                return this.head.toString();
            }
            String s = this.tail.toString();
            return this.head.toString() + " " + s.substring(1, s.length() - 1);
        }
        return this.head.toString() + " . " + this.tail.toString();
    }
}

