/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.StyledBlock;
import net.sf.xslthl.WholeHighlighter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MainHighlighter {
    List<Highlighter> highlighters = new LinkedList<Highlighter>();
    List<WholeHighlighter> wholehighlighters = new LinkedList<WholeHighlighter>();

    MainHighlighter() {
    }

    void add(Highlighter highlighter) {
        this.highlighters.add(highlighter);
    }

    void addWhole(WholeHighlighter wholeHighlighter) {
        this.wholehighlighters.add(wholeHighlighter);
    }

    List<Block> highlight(String string) {
        CharIter charIter = new CharIter(string);
        LinkedList<Block> linkedList = new LinkedList<Block>();
        if (this.highlighters.size() > 0) {
            while (!charIter.finished()) {
                Character c = charIter.current();
                boolean bl = false;
                for (Highlighter object : this.highlighters) {
                    if (!object.startsWith(charIter)) continue;
                    if (charIter.isMarked()) {
                        linkedList.add(charIter.markedToBlock());
                    }
                    if (!(bl = object.highlight(charIter, linkedList))) continue;
                    break;
                }
                if (bl) continue;
                charIter.moveNext();
            }
        } else {
            charIter.moveToEnd();
        }
        if (charIter.isMarked()) {
            linkedList.add(charIter.markedToBlock());
        }
        if (this.wholehighlighters.size() > 0) {
            for (WholeHighlighter wholeHighlighter : this.wholehighlighters) {
                LinkedList<Block> linkedList2 = linkedList;
                linkedList = new LinkedList();
                Iterator iterator = linkedList2.iterator();
                while (iterator.hasNext()) {
                    Block block = (Block)iterator.next();
                    if (block.isStyled() && (wholeHighlighter.appliesOnAllStyles() || wholeHighlighter.appliesOnStyle(((StyledBlock)block).getStyle())) || !block.isStyled() && wholeHighlighter.appliesOnEmptyStyle()) {
                        wholeHighlighter.highlight(new CharIter(block.getText()), linkedList);
                        continue;
                    }
                    linkedList.add(block);
                }
            }
        }
        return linkedList;
    }
}

