/*
 * Decompiled with CFR 0.152.
 */
package JSHOP2;

import JSHOP2.InternalAxiom;
import JSHOP2.InternalMethod;
import JSHOP2.InternalOperator;
import JSHOP2.JSHOP2Lexer;
import JSHOP2.JSHOP2Parser;
import JSHOP2.Predicate;
import JSHOP2.TaskList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class InternalDomain {
    private int planNo;
    private Vector axioms;
    private Vector calcs;
    private Vector compoundTasks;
    private Vector constants;
    private int constantsSize;
    static final String endl = System.getProperty("line.separator");
    private Vector methods;
    private String name;
    private Vector operators;
    private JSHOP2Parser parser;
    private Vector primitiveTasks;
    private String probName;

    public InternalDomain(File fin, int planNoIn) throws IOException {
        this.planNo = planNoIn;
        this.axioms = new Vector();
        this.calcs = new Vector();
        this.compoundTasks = new Vector();
        this.constants = new Vector();
        this.methods = new Vector();
        this.operators = new Vector();
        JSHOP2Lexer lexer = new JSHOP2Lexer(new FileInputStream(fin));
        this.parser = new JSHOP2Parser(lexer);
        this.parser.initialize(lexer, this);
        this.primitiveTasks = new Vector();
    }

    public void addAxiom(InternalAxiom axiom) {
        this.axioms.add(axiom);
    }

    public int addCompoundTask(String s) {
        int index = this.compoundTasks.indexOf(s);
        if (index == -1) {
            this.compoundTasks.add(s);
            return this.compoundTasks.size() - 1;
        }
        return index;
    }

    public int addConstant(String s) {
        int index = this.constants.indexOf(s);
        if (index == -1) {
            this.constants.add(s);
            return this.constants.size() - 1;
        }
        return index;
    }

    public void addCalc(String what) {
        if (!this.calcs.contains(what)) {
            this.calcs.add(what);
        }
    }

    public void addMethod(InternalMethod method) {
        this.methods.add(method);
    }

    public void addOperator(InternalOperator op) {
        this.operators.add(op);
    }

    public int addPrimitiveTask(String s) {
        int index = this.primitiveTasks.indexOf(s);
        if (index == -1) {
            this.primitiveTasks.add(s);
            return this.primitiveTasks.size() - 1;
        }
        return index;
    }

    public void close(int varsMaxSize) throws IOException {
        int i;
        String s = "import JSHOP2.*;" + endl + endl;
        for (i = 0; i < this.operators.size(); ++i) {
            s = s + ((InternalOperator)this.operators.get(i)).toCode();
        }
        for (i = 0; i < this.methods.size(); ++i) {
            s = s + ((InternalMethod)this.methods.get(i)).toCode();
        }
        for (i = 0; i < this.axioms.size(); ++i) {
            s = s + ((InternalAxiom)this.axioms.get(i)).toCode();
        }
        s = s + "public class " + this.name + " extends Domain" + endl + "{" + endl;
        for (i = 0; i < this.calcs.size(); ++i) {
            String imp = (String)this.calcs.get(i);
            s = s + "\tpublic static " + imp + " calculate" + imp + " = new " + imp + "();" + endl + endl;
        }
        s = s + "\tpublic " + this.name + "()" + endl + "\t{" + endl;
        s = s + "\t\tTermVariable.initialize(" + varsMaxSize + ");" + endl + endl;
        s = s + this.vectorToCode(this.constants, "constants");
        s = s + this.vectorToCode(this.compoundTasks, "compoundTasks");
        s = s + this.vectorToCode(this.primitiveTasks, "primitiveTasks");
        s = s + "\t\tmethods = new Method[" + this.compoundTasks.size() + "][];" + endl + endl;
        for (i = 0; i < this.compoundTasks.size(); ++i) {
            int j = 0;
            for (InternalMethod m : this.methods) {
                if (m.getHead().getHead() != i) continue;
                ++j;
            }
            s = s + "\t\tmethods[" + i + "] = new Method[" + j + "];" + endl;
            j = 0;
            for (InternalMethod m : this.methods) {
                if (m.getHead().getHead() != i) continue;
                s = s + "\t\tmethods[" + i + "][" + j++ + "] = new Method" + m.getCnt() + "();" + endl;
            }
            s = s + endl;
        }
        s = s + endl + "\t\tops = new Operator[" + this.primitiveTasks.size() + "][];" + endl + endl;
        for (i = 0; i < this.primitiveTasks.size(); ++i) {
            int j = 0;
            for (InternalOperator o : this.operators) {
                if (o.getHead().getHead() != i) continue;
                ++j;
            }
            s = s + "\t\tops[" + i + "] = new Operator[" + j + "];" + endl;
            j = 0;
            for (InternalOperator o : this.operators) {
                if (o.getHead().getHead() != i) continue;
                s = s + "\t\tops[" + i + "][" + j++ + "] = new Operator" + o.getCnt() + "();" + endl;
            }
            s = s + endl;
        }
        s = s + "\t\taxioms = new Axiom[" + this.constants.size() + "][];" + endl + endl;
        for (i = 0; i < this.constants.size(); ++i) {
            int j = 0;
            for (InternalAxiom a : this.axioms) {
                if (a.getHead().getHead() != i) continue;
                ++j;
            }
            s = s + "\t\taxioms[" + i + "] = new Axiom[" + j + "];" + endl;
            j = 0;
            for (InternalAxiom a : this.axioms) {
                if (a.getHead().getHead() != i) continue;
                s = s + "\t\taxioms[" + i + "][" + j++ + "] = new Axiom" + a.getCnt() + "();" + endl;
            }
            s = s + endl;
        }
        s = s + "\t}" + endl + "}";
        BufferedWriter dest = new BufferedWriter(new FileWriter(this.name + ".java"));
        dest.write(s, 0, s.length());
        dest.close();
        dest = new BufferedWriter(new FileWriter(this.name + ".txt"));
        this.dumpStringArray(dest, this.constants);
        this.dumpStringArray(dest, this.compoundTasks);
        this.dumpStringArray(dest, this.primitiveTasks);
        dest.close();
    }

    public void commandInitialize() throws IOException {
        BufferedReader src = new BufferedReader(new FileReader(this.name + ".txt"));
        this.constantsSize = this.readStringArray(src, this.constants);
        this.readStringArray(src, this.compoundTasks);
        this.readStringArray(src, this.primitiveTasks);
        src.close();
    }

    public void commandToCode(LinkedList states, LinkedList taskLists) throws IOException {
        String s = "import JSHOP2.*;" + endl + endl;
        s = s + "public class " + this.probName + endl + "{" + endl;
        s = s + "\tprivate static String[] defineConstants()" + endl + "\t{" + endl;
        s = s + "\t\tString[] problemConstants = new String[" + (this.constants.size() - this.constantsSize) + "];" + endl + endl;
        for (int i = this.constantsSize; i < this.constants.size(); ++i) {
            s = s + "\t\tproblemConstants[" + (i - this.constantsSize) + "] = \"" + (String)this.constants.get(i) + "\";" + endl;
        }
        s = s + endl + "\t\treturn problemConstants;" + endl + "\t}" + endl + endl;
        Iterator e = states.iterator();
        int problemIdx = 0;
        while (e.hasNext()) {
            s = s + "\tprivate static void createState" + problemIdx++ + "(State s)" + "\t{" + endl;
            Vector state = (Vector)e.next();
            for (int i = 0; i < state.size(); ++i) {
                Predicate p = (Predicate)state.get(i);
                if (p.getHead() >= this.constantsSize) continue;
                s = s + "\t\ts.add(" + p.toCode() + ");" + endl;
            }
            s = s + "\t}" + endl + endl;
        }
        s = s + "\tpublic static void main(String[] args) throws InterruptedException" + endl + "\t{" + endl;
        s = s + "\t\tTermConstant.initialize(" + this.constants.size() + ");" + endl + endl;
        s = s + "\t\tDomain d = new " + this.name + "();" + endl + endl;
        s = s + "\t\td.setProblemConstants(defineConstants());" + endl + endl;
        s = s + "\t\tState s = new State(" + this.constantsSize + ", d.getAxioms());" + endl;
        s = s + endl + "\t\tJSHOP2.initialize(d, s);" + endl + endl;
        s = s + "\t\tTaskList tl;" + endl + "\t\tThread thread;" + endl + endl;
        e = taskLists.iterator();
        problemIdx = 0;
        while (e.hasNext()) {
            if (problemIdx != 0) {
                s = s + endl + "\t\ts.clear();" + endl;
            }
            s = s + "\t\tcreateState" + problemIdx + "(s);" + endl;
            TaskList tl = (TaskList)e.next();
            s = s + endl + tl.getInitCode("tl") + endl;
            s = s + "\t\tthread = new SolverThread(tl, " + this.planNo + ");" + endl;
            s = s + "\t\tthread.start();" + endl;
            s = s + "\t\twhile (thread.isAlive())" + endl + "\t\t\tThread.sleep(500);" + endl;
            ++problemIdx;
        }
        s = s + "\t}" + endl + "}";
        BufferedWriter dest = new BufferedWriter(new FileWriter(this.probName + ".java"));
        dest.write(s, 0, s.length());
        dest.close();
    }

    public void dumpStringArray(BufferedWriter dest, Vector list) throws IOException {
        String buff = list.size() + endl;
        dest.write(buff, 0, buff.length());
        for (int i = 0; i < list.size(); ++i) {
            buff = list.get(i) + endl;
            dest.write(buff, 0, buff.length());
        }
    }

    public int getAxiomNo() {
        return this.axioms.size();
    }

    public Vector getCompoundTasks() {
        return this.compoundTasks;
    }

    public Vector getConstants() {
        return this.constants;
    }

    public int getMethodNo() {
        return this.methods.size();
    }

    public String getName() {
        return this.name;
    }

    public Vector getPrimitiveTasks() {
        return this.primitiveTasks;
    }

    public static void main(String[] args) throws Exception {
        int planNo = -1;
        if (args.length == 2 || args[0].substring(0, 2).equals("-r")) {
            if (args[0].equals("-r")) {
                planNo = 1;
            } else if (args[0].equals("-ra")) {
                planNo = Integer.MAX_VALUE;
            } else {
                try {
                    planNo = Integer.parseInt(args[0].substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((args.length != 2 || planNo <= 0) && args.length != 1) {
            System.err.println("usage: java JSHOP2Parser [-r|-ra|-rSomePositiveInteger] input");
            System.exit(1);
        }
        if (args.length == 2) {
            new InternalDomain((File)new File((String)args[1]), (int)planNo).parser.command();
        } else {
            new InternalDomain((File)new File((String)args[0]), (int)-1).parser.domain();
        }
    }

    public int readStringArray(BufferedReader src, Vector list) throws IOException {
        String buff = src.readLine();
        int j = Integer.valueOf(buff);
        for (int i = 0; i < j; ++i) {
            buff = src.readLine();
            list.add(buff);
        }
        return j;
    }

    public void setName(String nameIn) {
        this.name = nameIn;
    }

    public void setProbName(String probNameIn) {
        this.probName = probNameIn;
    }

    public String vectorToCode(Vector list, String name) {
        String retVal = "\t\t" + name + " = new String[" + list.size() + "];" + endl;
        for (int i = 0; i < list.size(); ++i) {
            retVal = retVal + "\t\t" + name + "[" + i + "] = \"" + list.get(i) + "\";" + endl;
        }
        return retVal + endl;
    }
}

