/*
 * Decompiled with CFR 0.152.
 */
package JSHOP2;

import JSHOP2.DelAddElement;
import JSHOP2.LogicalExpression;
import JSHOP2.NumberedPredicate;
import JSHOP2.Precondition;
import JSHOP2.Predicate;
import JSHOP2.State;
import JSHOP2.Term;
import java.util.Vector;

public class DelAddForAll
extends DelAddElement {
    private Predicate[] atoms;
    private static int classCnt = 0;
    private int cnt;
    private LogicalExpression exp;
    private Precondition pre;

    public DelAddForAll(LogicalExpression expIn, Vector atomsIn) {
        this.exp = expIn;
        this.atoms = new Predicate[atomsIn.size()];
        for (int i = 0; i < this.atoms.length; ++i) {
            this.atoms[i] = (Predicate)atomsIn.get(i);
        }
        this.cnt = classCnt++;
    }

    public DelAddForAll(Precondition preIn, Predicate[] atomsIn) {
        this.pre = preIn;
        this.atoms = atomsIn;
    }

    public void add(State s, Term[] binding, Vector[] delAddList) {
        Term[] nextB;
        this.pre.reset();
        this.pre.bind(binding);
        while ((nextB = this.pre.nextBinding()) != null) {
            Term.merge(nextB, binding);
            for (int i = 0; i < this.atoms.length; ++i) {
                Predicate p = this.atoms[i].applySubstitution(nextB);
                if (!s.add(p)) continue;
                delAddList[1].add(p);
            }
        }
    }

    public boolean del(State s, Term[] binding, Vector[] delAddList) {
        Term[] nextB;
        this.pre.reset();
        this.pre.bind(binding);
        while ((nextB = this.pre.nextBinding()) != null) {
            Term.merge(nextB, binding);
            for (int i = 0; i < this.atoms.length; ++i) {
                Predicate p = this.atoms[i].applySubstitution(nextB);
                if (s.isProtected(p)) {
                    return false;
                }
                int index = s.del(p);
                if (index == -1) continue;
                delAddList[0].add(new NumberedPredicate(p, index));
            }
        }
        return true;
    }

    public String getExpCode() {
        return this.exp.getInitCode();
    }

    public String getInitCode() {
        int i;
        String retVal = "\t\tunifier = new Term[" + this.exp.getVarCount() + "];" + endl;
        for (i = 0; i < this.exp.getVarCount(); ++i) {
            retVal = retVal + endl + "\t\tunifier[" + i + "] = null;";
        }
        retVal = retVal + endl + endl + "\t\tPredicate[] atoms" + this.cnt + " = {" + endl;
        for (i = 0; i < this.atoms.length; ++i) {
            retVal = retVal + "\t\t\t" + this.atoms[i].toCode();
            if (i == this.atoms.length - 1) continue;
            retVal = retVal + "," + endl;
        }
        return retVal + " };" + endl;
    }

    public void setVarCount(int varCount) {
        this.exp.setVarCount(varCount);
        for (int i = 0; i < this.atoms.length; ++i) {
            this.atoms[i].setVarCount(varCount);
        }
    }

    public String toCode() {
        return "new DelAddForAll(" + this.exp.toCode() + ", atoms" + this.cnt + ")";
    }
}

