/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.preprocessor.tokenization;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import se.lth.cs.srl.preprocessor.tokenization.Tokenizer;

public class OpenNLPToolsTokenizerWrapper
implements Tokenizer {
    opennlp.tools.tokenize.Tokenizer tokenizer;

    public OpenNLPToolsTokenizerWrapper(opennlp.tools.tokenize.Tokenizer tokenizerImplementation) {
        this.tokenizer = tokenizerImplementation;
    }

    @Override
    public String[] tokenize(String sentence) {
        String[] tokens = this.tokenizer.tokenize(sentence);
        String[] withRoot = new String[tokens.length + 1];
        withRoot[0] = "<root>";
        System.arraycopy(tokens, 0, withRoot, 1, tokens.length);
        return withRoot;
    }

    public static OpenNLPToolsTokenizerWrapper loadOpenNLPTokenizer(File modelFile) throws IOException {
        BufferedInputStream modelIn = new BufferedInputStream(new FileInputStream(modelFile.toString()));
        TokenizerME tokenizer = new TokenizerME(new TokenizerModel((InputStream)modelIn));
        return new OpenNLPToolsTokenizerWrapper((opennlp.tools.tokenize.Tokenizer)tokenizer);
    }
}

