/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.pipeline;

import java.util.List;
import java.util.TreeSet;
import se.lth.cs.srl.Learn;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.Feature;
import se.lth.cs.srl.features.FeatureSet;
import se.lth.cs.srl.ml.LearningProblem;
import se.lth.cs.srl.ml.Model;
import se.lth.cs.srl.pipeline.AbstractStep;
import se.lth.cs.srl.util.Constant;

public class PredicateIdentifier
extends AbstractStep {
    private static final String FILEPREFIX = "pi_";

    public PredicateIdentifier(FeatureSet fs) {
        super(fs);
    }

    @Override
    public void extractInstances(Sentence s) {
        int size = s.size();
        for (int i = 1; i < size; ++i) {
            Integer label;
            Word potentialPredicate = (Word)s.get(i);
            String POS = potentialPredicate.getPOS();
            String POSPrefix = null;
            for (String prefix : this.featureSet.POSPrefixes) {
                if (!POS.startsWith(prefix)) continue;
                POSPrefix = prefix;
                break;
            }
            if (POSPrefix == null) {
                if (Learn.learnOptions.skipNonMatchingPredicates || !(potentialPredicate instanceof Predicate)) continue;
                POSPrefix = this.featureSet.POSPrefixes[0];
            }
            Integer n = label = potentialPredicate instanceof Predicate ? POSITIVE : NEGATIVE;
            if (((Word)s.get(i)).getIgnoredPredicate()) continue;
            this.addInstance(s, i, POSPrefix, label);
        }
    }

    private void addInstance(Sentence s, int i, String POSPrefix, Integer label) {
        LearningProblem lp = (LearningProblem)this.learningProblems.get(POSPrefix);
        TreeSet<Integer> indices = new TreeSet<Integer>();
        Integer offset = 0;
        for (Feature f : (List)this.featureSet.get(POSPrefix)) {
            f.addFeatures(s, indices, i, -1, offset, true);
            offset = offset + f.size(true);
        }
        if (Constant.PI_useStartExtention != -1) {
            lp.addInstance(label, indices, ((Word)s.get(i)).getSparseEntensions(), Constant.PI_useStartExtention, Constant.PI_useEndExtention, offset);
        } else {
            lp.addInstance(label, indices);
        }
    }

    @Override
    public void parse(Sentence s) {
        int size = s.size();
        for (int i = 1; i < size; ++i) {
            Integer label = this.classifyInstance(s, i);
            if (!label.equals(POSITIVE)) continue;
            s.makePredicate(i);
        }
    }

    private Integer classifyInstance(Sentence s, int i) {
        String POSPrefix = null;
        String POS = ((Word)s.get(i)).getPOS();
        for (String prefix : this.featureSet.POSPrefixes) {
            if (!POS.startsWith(prefix)) continue;
            POSPrefix = prefix;
            break;
        }
        if (POSPrefix == null) {
            return NEGATIVE;
        }
        Model m = (Model)this.models.get(POSPrefix);
        TreeSet<Integer> indices = new TreeSet<Integer>();
        Integer offset = 0;
        for (Feature f : (List)this.featureSet.get(POSPrefix)) {
            f.addFeatures(s, indices, i, -1, offset, true);
            offset = offset + f.size(true);
        }
        return m.classify(indices);
    }

    @Override
    public void prepareLearning() {
        super.prepareLearning(FILEPREFIX);
    }

    @Override
    protected String getModelFileName() {
        return "pi_.models";
    }
}

