/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.options;

import java.io.File;
import se.lth.cs.srl.languages.Language;
import se.lth.cs.srl.options.LearnOptions;
import se.lth.cs.srl.pipeline.Step;

public class FeatureSelectionOptions {
    public Step step;
    public String POSPrefix;
    public File startingFeatureFile;
    public File trainingCorpus;
    public File tempDir;
    public File llbinary;
    public boolean crossValidated = false;
    public int partitions = 5;
    public double threshold = 0.001;
    public boolean deterministicPipeline = true;
    public boolean randomizeInput = false;
    public boolean dropSentencesWithoutPredicates = true;
    public boolean quadratic = false;
    public boolean includeFeats = false;
    public boolean skipUnknownPredicates = false;

    public FeatureSelectionOptions(String[] args) {
        Language.L l = Language.L.valueOf(args[0]);
        Language.setLanguage(l);
        this.step = Step.valueOf(args[1]);
        int ai = 2;
        while (ai < args.length) {
            if (args[ai].equals("-prefix")) {
                this.POSPrefix = args[++ai];
                ++ai;
                continue;
            }
            if (args[ai].equals("-train")) {
                this.trainingCorpus = new File(args[++ai]);
                ++ai;
                continue;
            }
            if (args[ai].equals("-crossValidated")) {
                ++ai;
                this.crossValidated = true;
                continue;
            }
            if (args[ai].equals("-startFeatureFile")) {
                this.startingFeatureFile = new File(args[++ai]);
                ++ai;
                continue;
            }
            if (args[ai].equals("-partitions")) {
                this.partitions = Integer.parseInt(args[++ai]);
                ++ai;
                continue;
            }
            if (args[ai].equals("-randomize")) {
                ++ai;
                this.randomizeInput = true;
                continue;
            }
            if (args[ai].equals("-keepAll")) {
                ++ai;
                this.dropSentencesWithoutPredicates = false;
                continue;
            }
            if (args[ai].equals("-threshold")) {
                this.threshold = Double.parseDouble(args[++ai]);
                ++ai;
                continue;
            }
            if (args[ai].equals("-quadratic")) {
                ++ai;
                this.quadratic = true;
                continue;
            }
            if (args[ai].equals("-includeFeats")) {
                ++ai;
                this.includeFeats = true;
                continue;
            }
            if (args[ai].equals("-skipUnknownPredicates")) {
                ++ai;
                this.skipUnknownPredicates = true;
                continue;
            }
            if (args[ai].equals("-llbinary")) {
                this.llbinary = new File(args[++ai]);
                ++ai;
                continue;
            }
            System.err.println("Unknown option: " + args[ai]);
            System.exit(1);
        }
        this.tempDir = LearnOptions.setupTempDir();
    }

    public void verifyArguments() {
        if (this.trainingCorpus == null || !this.trainingCorpus.exists() || !this.trainingCorpus.canRead()) {
            System.err.println("You forgot to specify training corpus, or the file does not exist. Aborting.");
            System.exit(1);
        }
        if (!(this.startingFeatureFile == null || this.startingFeatureFile.exists() && this.startingFeatureFile.canRead())) {
            System.err.println("The starting feature file does not exist or can not be read. Aborting.");
            System.exit(1);
        }
    }

    public LearnOptions getLearnOptions() {
        LearnOptions options = new LearnOptions();
        options.skipNonMatchingPredicates = this.skipUnknownPredicates;
        options.tempDir = this.tempDir;
        options.deterministicPipeline = this.deterministicPipeline;
        options.liblinearBinary = this.llbinary;
        return options;
    }
}

