/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.languages;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.languages.Language;
import se.lth.cs.srl.options.FullPipelineOptions;

public class Spanish
extends Language {
    private static final Pattern CALSPattern = Pattern.compile("((arg0|arg1|arg2|arg3|arg4)-[a-z]+)");
    private static final boolean useVoice = false;

    private boolean isPassive(Predicate pred) {
        for (Word c : pred.getChildren()) {
            if (!c.getLemma().equals("estar") && !c.getLemma().equals("ser") || !c.getFeats().contains("auxiliary")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCoreArgumentLabelSequence(Predicate pred, Map<Word, String> proposition) {
        Sentence s = pred.getMySentence();
        StringBuffer ret = new StringBuffer();
        for (int i = 1; i < s.size(); ++i) {
            Matcher m;
            Word w = (Word)s.get(i);
            if (pred == w) {
                ret.append(" ").append(pred.getSense());
            }
            if (!proposition.containsKey(w) || !(m = CALSPattern.matcher(proposition.get(w))).matches()) continue;
            ret.append(" ").append(m.group(1));
        }
        return ret.toString();
    }

    @Override
    public String getDefaultSense(Predicate pred) {
        String PFeat = pred.getFeats();
        String label = PFeat.contains("postype=auxiliary") ? "c2" : (PFeat.contains("postype=common") ? "a2" : (PFeat.contains("postype=main") ? "a2" : (PFeat.contains("postype=qualificative") ? "b2" : (PFeat.contains("postype=semiauxiliary") ? "c2" : "a2"))));
        return pred.getLemma() + "." + label;
    }

    @Override
    public Language.L getL() {
        return Language.L.spa;
    }

    @Override
    public String getLexiconURL(Predicate pred) {
        return "http://clic.ub.edu/mbertran/ancora/lexentry.php?file=" + pred.getLemma() + ".lex.xml&lexicon=AnCoraVerb_ES";
    }

    @Override
    public String verifyLanguageSpecificModelFiles(FullPipelineOptions options) {
        return null;
    }

    @Override
    public String toLangNameString() {
        return "Spanish";
    }
}

