/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.io.SentenceWriter;

public class CoNLL09Writer
implements SentenceWriter {
    private BufferedWriter out;

    public CoNLL09Writer(File filename) {
        System.out.println("Writing corpus to " + filename + "...");
        try {
            this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), Charset.forName("UTF-8")));
        }
        catch (IOException e) {
            System.out.println("Failed while opening writer...\n" + e.toString());
            System.exit(1);
        }
    }

    @Override
    public void write(Sentence s) {
        try {
            this.out.write(s.toString() + "\n\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Failed to write sentance.");
            System.exit(1);
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Failed to close writer.");
            System.exit(1);
        }
    }
}

