/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.io.SentenceReader;
import se.lth.cs.srl.util.Constant;

public abstract class AbstractCoNLL09Reader
implements SentenceReader {
    protected static final Pattern NEWLINE_PATTERN = Pattern.compile("\n");
    protected BufferedReader in;
    protected Sentence nextSen;
    private File file;
    protected BufferedReader extensionIn;
    private File extensionFile;

    public AbstractCoNLL09Reader(File file) {
        this.file = file;
        this.open();
    }

    public AbstractCoNLL09Reader(File file, File extensionFile) {
        this.file = file;
        this.extensionFile = extensionFile;
        this.open();
    }

    private void restart() {
        try {
            this.in.close();
            this.open();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void open() {
        System.out.println("Opening reader for " + this.file + "...");
        try {
            this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), Charset.forName("UTF-8")));
            if (this.extensionFile != null) {
                this.extensionIn = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.extensionFile), Charset.forName("UTF-8")));
                if (this.extensionIn != null) {
                    try {
                        if (Constant.extensionIsSparseFormat) {
                            this.extensionIn.readLine();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.readNextSentence();
        }
        catch (IOException e) {
            System.out.println("Failed: " + e.toString());
            System.exit(1);
        }
    }

    protected abstract void readNextSentence() throws IOException;

    private Sentence getSentence() {
        Sentence ret = this.nextSen;
        try {
            this.readNextSentence();
        }
        catch (IOException e) {
            System.out.println("Failed to read from corpus file... exiting.");
            System.exit(1);
        }
        return ret;
    }

    @Override
    public List<Sentence> readAll() {
        ArrayList<Sentence> ret = new ArrayList<Sentence>();
        for (Sentence s : this) {
            ret.add(s);
        }
        ret.trimToSize();
        return ret;
    }

    @Override
    public Iterator<Sentence> iterator() {
        if (this.nextSen == null) {
            this.restart();
        }
        return new SentenceIterator();
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected boolean extensionIsSparseFile() {
        try {
            String str;
            while ((str = this.extensionIn.readLine()) != null) {
                if (str.contains("***Size:")) {
                    int size;
                    String[] tmps = str.split(":");
                    Constant.TOTAL_EXTENSION_FEATURE = size = Integer.parseInt(tmps[1]);
                    return true;
                }
                if (str.matches("\\s*")) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private class SentenceIterator
    implements Iterator<Sentence> {
        private SentenceIterator() {
        }

        @Override
        public boolean hasNext() {
            return AbstractCoNLL09Reader.this.nextSen != null;
        }

        @Override
        public Sentence next() {
            return AbstractCoNLL09Reader.this.getSentence();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

