/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.ArgDependentAttrFeature;
import se.lth.cs.srl.features.FeatureName;
import se.lth.cs.srl.features.TargetWord;
import se.lth.cs.srl.util.BrownCluster;

public class ArgDependentBrown
extends ArgDependentAttrFeature {
    private static final long serialVersionUID = 1L;
    private BrownCluster bc;
    private BrownCluster.ClusterVal cv;

    protected ArgDependentBrown(FeatureName name, TargetWord tw, String POSPrefix, BrownCluster bc, BrownCluster.ClusterVal cv) {
        super(name, null, tw, POSPrefix);
        this.bc = bc;
        this.cv = cv;
    }

    @Override
    protected void performFeatureExtraction(Sentence s, boolean allWords) {
        for (Predicate p : s.getPredicates()) {
            if (!this.doExtractFeatures(p)) continue;
            for (Word arg : p.getArgMap().keySet()) {
                Word w = this.wordExtractor.getWord(null, arg);
                if (w == null) continue;
                this.addMap(this.bc.getValue(w.getForm(), this.cv));
            }
        }
    }

    @Override
    public String getFeatureString(Sentence s, int predIndex, int argIndex) {
        Word w = this.wordExtractor.getWord(s, predIndex, argIndex);
        if (w == null) {
            return null;
        }
        return this.bc.getValue(w.getForm(), this.cv);
    }

    @Override
    public String getFeatureString(Predicate pred, Word arg) {
        Word w = this.wordExtractor.getWord(pred, arg);
        if (w == null) {
            return null;
        }
        return this.bc.getValue(w.getForm(), this.cv);
    }
}

