/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.srl.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import liir.tools.resources.nombank.NombankReader;
import se.lth.cs.srl.SemanticRoleLabeler;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.corpus.Yield;
import se.lth.cs.srl.languages.Language;
import se.lth.cs.srl.options.CompletePipelineCMDLineOptions;
import se.lth.cs.srl.options.ParseOptions;
import se.lth.cs.srl.pipeline.Pipeline;
import se.lth.cs.srl.pipeline.Reranker;
import se.lth.cs.srl.pipeline.Step;
import se.lth.cs.srl.preprocessor.Preprocessor;

public class MuseInterfaceSmall {
    private static Preprocessor pp;
    private SemanticRoleLabeler srl;
    private static CompletePipelineCMDLineOptions options;
    public static ParseOptions parseOptions;
    private static MuseInterfaceSmall instance;
    private static NombankReader reader;
    private static Hashtable<String, String> role_map;

    public static synchronized MuseInterfaceSmall getInstance(String lemmatizerModel, String posModel, String parserModel, String srlModel, boolean useReranker, String PBsource, String NBsource) throws Exception {
        if (instance == null) {
            instance = new MuseInterfaceSmall(lemmatizerModel, posModel, parserModel, srlModel, useReranker, PBsource, NBsource);
        }
        return instance;
    }

    private MuseInterfaceSmall(String lemmatizerModel, String posModel, String parserModel, String srlModel, boolean useReranker, String PBsource, String NBsource) throws Exception {
        role_map.put("AM-ADV", "Adverb");
        role_map.put("AM-DIR", "Direction");
        role_map.put("AM-DIS", "Discourse");
        role_map.put("AM-LOC", "Location");
        role_map.put("AM-MNR", "Manner");
        role_map.put("AM-MOD", "Modal");
        role_map.put("AM-NEG", "Negation");
        role_map.put("AM-PNC", "Purpose");
        role_map.put("AM-TMP", "Time");
        role_map.put("AM-CAU", "Cause");
        role_map.put("AM-PRD", "Secondary Predication");
        role_map.put("AM-EXT", "Extention");
        role_map.put("AM-REC", "Reciprocal argument");
        Language.setLanguage(Language.L.eng);
        parseOptions = new ParseOptions(srlModel, useReranker);
        options = new CompletePipelineCMDLineOptions();
        options = new CompletePipelineCMDLineOptions();
        if (lemmatizerModel != null) {
            MuseInterfaceSmall.options.lemmatizer = new File(lemmatizerModel);
        }
        if (posModel != null) {
            MuseInterfaceSmall.options.tagger = new File(posModel);
        }
        if (parserModel != null) {
            MuseInterfaceSmall.options.parser = new File(parserModel);
        }
        reader = new NombankReader();
        if (PBsource != null) {
            reader.readDir(PBsource, false);
        }
        if (NBsource != null) {
            reader.readDir(NBsource, true);
        }
        pp = Language.getLanguage().getPreprocessor(options);
        if (MuseInterfaceSmall.parseOptions.useReranker) {
            this.srl = new Reranker(parseOptions);
        } else {
            ZipFile zipFile = new ZipFile(MuseInterfaceSmall.parseOptions.modelFile);
            this.srl = MuseInterfaceSmall.parseOptions.skipPI ? Pipeline.fromZipFile(zipFile, new Step[]{Step.pd, Step.ai, Step.ac}) : Pipeline.fromZipFile(zipFile);
            zipFile.close();
        }
    }

    public Map<Integer, Map<String, List<List<Integer>>>> parse(List<String> text) throws IOException {
        Sentence s;
        String[] textt = text.toArray(new String[text.size()]);
        if (MuseInterfaceSmall.options.parser != null) {
            String[] textt2 = new String[text.size() + 1];
            String[] textt3 = new String[text.size() + 1];
            String[] textt4 = new String[text.size() + 1];
            textt2[0] = "";
            for (int i = 0; i < textt.length; ++i) {
                String[] tmps = textt[i].split("\\s+");
                if (tmps.length > 1) {
                    textt2[i + 1] = tmps[1];
                    textt3[i + 1] = tmps[3];
                    textt4[i + 1] = tmps[5];
                    continue;
                }
                textt2[i + 1] = tmps[0];
            }
            s = new Sentence(pp.preprocess(textt2, textt3, textt4), false);
        } else {
            s = Sentence.newDepsOnlySentence(textt);
        }
        System.out.println("Start parsing... ");
        this.srl.parseSentence(s);
        System.out.println("Finish!");
        return this.getResults(s);
    }

    private String findVNRole(String predicate, String pos, String frame, String role) {
        String prefix = "";
        String main = null;
        String rs = role;
        if (role.startsWith("R-")) {
            prefix = "Relation-";
            role = role.substring(2);
            main = reader.getVnrole(predicate, pos, frame, role);
        }
        if (role.startsWith("C-")) {
            prefix = "Continuation-";
            role = role.substring(2);
            main = reader.getVnrole(predicate, pos, frame, role);
        }
        if (role.startsWith("A")) {
            main = reader.getVnrole(predicate, pos, frame, role);
        }
        if (role.startsWith("AM-") && role_map.containsKey(role)) {
            main = role_map.get(role);
        }
        if (main == null) {
            return rs;
        }
        return prefix + main;
    }

    private Map<Integer, Map<String, List<List<Integer>>>> getResults(Sentence s) {
        HashMap<Integer, Map<String, List<List<Integer>>>> m = new HashMap<Integer, Map<String, List<List<Integer>>>>();
        for (Predicate pred : s.getPredicates()) {
            String predicate = pred.getLemma();
            String frame = pred.getSense();
            String pos = pred.getPOS().substring(0, 1);
            ArrayList<String> roles = new ArrayList<String>();
            HashMap mp = new HashMap();
            mp.put("SENSE---" + pred.getSense(), null);
            for (Word w : pred.getArgMap().keySet()) {
                if (roles.contains(pred.getArgumentTag(w))) continue;
                roles.add(pred.getArgumentTag(w));
            }
            Collections.sort(roles);
            TreeSet<Yield> yields = new TreeSet<Yield>();
            Map<Word, String> argmap = pred.getArgMap();
            for (Word arg : argmap.keySet()) {
                yields.addAll(arg.getYield(pred, argmap.get(arg), argmap.keySet()).explode());
            }
            for (String role : roles) {
                String vb_role = this.findVNRole(predicate, pos, frame, role);
                ArrayList lst = new ArrayList();
                for (Yield y : yields) {
                    if (!y.getArgLabel().equals(role)) continue;
                    ArrayList<Integer> l = new ArrayList<Integer>();
                    if (!y.isContinuous()) {
                        System.out.println("Something wrong, we have discontinous yields!");
                        continue;
                    }
                    int first = s.indexOf(y.first());
                    int end = s.indexOf(y.last());
                    for (int j = first; j <= end; ++j) {
                        l.add(j);
                    }
                    lst.add(l);
                }
                mp.put(role + ":" + vb_role, lst);
            }
            m.put(s.indexOf(pred), mp);
        }
        return m;
    }

    public static void main(String[] args) throws Exception {
        MuseInterfaceSmall mi = MuseInterfaceSmall.getInstance(null, null, null, "/Users/quynhdo/Documents/workspace/SRLWorkspace/Lund/pg-srl.mdl", false, null, null);
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("1\tOver\tover\tover\tIN\tIN\t_\t_\t7\t7\tPREP\tPREP\t_\t_\t_");
        lst.add("2\tseveral\tseveral\tseveral\tJJ\tJJ\t_\t_\t3\t3\tAMOD\tAMOD\t_\t_\t_");
        lst.add("3\tmonths\tmonth\tmonth\tNNS\tNNS\t_\t_\t1\t1\tPOBJ\tPOBJ\t_\t_\t_");
        lst.add("4\t,\t,\t,\t,\t,\t_\t_\t7\t7\tPUNCT\tPUNCT\t_\t_\t_");
        lst.add("5\tyou\tyou\tyou\tPRP\tPRP\t_\t_\t7\t7\tNSUBJ\tNSUBJ\t_\t_\t_");
        lst.add("6\twill\twill\twill\tMD\tMD\t_\t_\t7\t7\tAUX\tAUX\t_\t_\t_");
        lst.add("7\tmeet\tmeet\tmeet\tVB\tVB\t_\t_\t0\t0\tNULL\tNULL\t_\t_\t_");
        lst.add("8\tvarious\tvarious\tvarious\tJJ\tJJ\t_\t_\t9\t9\tAMOD\tAMOD\t_\t_\t_");
        lst.add("9\tprofessionals\tprofessional\tprofessional\tNNS\tNNS\t_\t_\t7\t7\tDOBJ\tDOBJ\t_\t_\t_");
        lst.add("10\twho\twho\twho\tWP\tWP\t_\t_\t12\t12\tNSUBJ\tNSUBJ\t_\t_\t_");
        lst.add("11\tare\tbe\tbe\tVBP\tVBP\t_\t_\t12\t12\tCOP\tCOP\t_\t_\t_");
        lst.add("12\tmembers\tmember\tmember\tNNS\tNNS\t_\t_\t9\t9\tRCMOD\tRCMOD\t_\t_\t_");
        lst.add("13\tof\tof\tof\tIN\tIN\t_\t_\t12\t12\tPREP\tPREP\t_\t_\t_");
        lst.add("14\ta\ta\ta\tDT\tDT\t_\t_\t16\t16\tDET\tDET\t_\t_\t_");
        lst.add("15\tmultidisciplinary\tmultidisciplinary\tmultidisciplinary\tJJ\tJJ\t_\t_\t16\t16\tAMOD\tAMOD\t_\t_\t_");
        lst.add("16\tteam\tteam\tteam\tNN\tNN\t_\t_\t13\t13\tPOBJ\tPOBJ\t_\t_\t_");
        lst.add("17\t(\t-lrb-\t-lrb-\t(\t(\t_\t_\t35\t35\tPUNCT\tPUNCT\t_\t_\t_");
        lst.add("18\tsurgeon\tsurgeon\tsurgeon\tNN\tNN\t_\t_\t21\t21\tNN\tNN\t_\t_\tactor.med.professional");
        lst.add("19\t,\t,\t,\t,\t,\t_\t_\t21\t21\tPUNCT\tPUNCT\t_\t_\t_");
        lst.add("20\tnutrition\tnutrition\tnutrition\tNN\tNN\t_\t_\t21\t21\tDEP\tDEP\t_\t_\t_");
        lst.add("21\tdoctor\tdoctor\tdoctor\tNN\tNN\t_\t_\t35\t35\tDEP\tDEP\t_\t_\tactor.med.professional");
        lst.add("22\t,\t,\t,\t,\t,\t_\t_\t21\t21\tPUNCT\tPUNCT\t_\t_\t_");
        lst.add("23\tdietician\tdietician\tdietician\tNN\tNN\t_\t_\t21\t21\tCONJ\tCONJ\t_\t_\tactor.med.professional");
        lst.add("24\t,\t,\t,\t,\t,\t_\t_\t21\t21\tPUNCT\tPUNCT\t_\t_\t_");
        lst.add("25\tpsychiatrist\tpsychiatrist\tpsychiatrist\tNN\tNN\t_\t_\t21\t21\tCONJ\tCONJ\t_\t_\tactor.med.professional");
        lst.add("26\tor\tor\tor\tCC\tCC\t_\t_\t21\t21\tCC\tCC\t_\t_\t_");
        lst.add("27\tpsychologist\tpsychologist\tpsychologist\tNN\tNN\t_\t_\t21\t21\tCONJ\tCONJ\t_\t_\tactor.med.professional");
        lst.add("28\t,\t,\t,\t,\t,\t_\t_\t21\t21\tPUNCT\tPUNCT\t_\t_\t_");
        lst.add("29\tanaesthetist\tanaesthetist\tanaesthetist\tNN\tNN\t_\t_\t21\t21\tAPPOS\tAPPOS\t_\t_\tactor.med.professional");
        lst.add("30\t,\t,\t,\t,\t,\t_\t_\t21\t21\tPUNCT\tPUNCT\t_\t_\t_");
        lst.add("31\tetc.\tetc.\tetc.\tFW\tFW\t_\t_\t21\t21\tDEP\tDEP\t_\t_\tactor.med.professional");
        lst.add("32\t)\t-rrb-\t-rrb-\t)\t)\t_\t_\t35\t35\tPUNCT\tPUNCT\t_\t_\t_");
        lst.add("33\twho\twho\twho\tWP\tWP\t_\t_\t35\t35\tNSUBJ\tNSUBJ\t_\t_\t_");
        lst.add("34\twill\twill\twill\tMD\tMD\t_\t_\t35\t35\tAUX\tAUX\t_\t_\t_");
        lst.add("35\tprovide\tprovide\tprovide\tVB\tVB\t_\t_\t16\t16\tDEP\tDEP\tY\tprovide.information\t_");
        lst.add("36\tyou\tyou\tyou\tPRP\tPRP\t_\t_\t35\t35\tDOBJ\tDOBJ\t_\t_\tactor.patient");
        lst.add("37\twith\twith\twith\tIN\tIN\t_\t_\t35\t35\tPREP\tPREP\t_\t_\t_");
        lst.add("38\tinformation\tinformation\tinformation\tNN\tNN\t_\t_\t37\t37\tPOBJ\tPOBJ\t_\t_\t_");
        lst.add("39\tand\tand\tand\tCC\tCC\t_\t_\t35\t35\tCC\tCC\t_\t_\t_");
        lst.add("40\texamine\texamine\texamine\tVB\tVB\t_\t_\t35\t35\tCONJ\tCONJ\t_\t_\t_");
        lst.add("41\tyou\tyou\tyou\tPRP\tPRP\t_\t_\t40\t40\tDOBJ\tDOBJ\t_\t_\t_");
        lst.add("42\t.\t.\t.\t.\t.\t_\t_\t7\t7\tPUNCT\tPUNCT\t_\t_\t_");
        Map<Integer, Map<String, List<List<Integer>>>> tmp = mi.parse(lst);
        System.out.println(tmp.toString());
    }

    static {
        role_map = new Hashtable();
    }
}

