/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.srl.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import se.lth.cs.srl.SemanticRoleLabeler;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.corpus.Yield;
import se.lth.cs.srl.io.DepsOnlyCoNLL09Reader;
import se.lth.cs.srl.languages.Language;
import se.lth.cs.srl.options.ParseOptions;
import se.lth.cs.srl.pipeline.Pipeline;
import se.lth.cs.srl.pipeline.Reranker;
import se.lth.cs.srl.pipeline.Step;

public class MuseInterface {
    SemanticRoleLabeler srl;
    public static ParseOptions parseOptions;
    private static MuseInterface instance;

    public static synchronized MuseInterface getInstance(String modelPath, boolean useReranker) throws Exception {
        if (instance == null) {
            instance = new MuseInterface(modelPath, useReranker);
        }
        return instance;
    }

    private MuseInterface(String modelPath, boolean useReranker) throws Exception {
        Language.setLanguage(Language.L.eng);
        parseOptions = new ParseOptions(modelPath, useReranker);
        if (MuseInterface.parseOptions.useReranker) {
            this.srl = new Reranker(parseOptions);
        } else {
            ZipFile zipFile = new ZipFile(MuseInterface.parseOptions.modelFile);
            this.srl = MuseInterface.parseOptions.skipPI ? Pipeline.fromZipFile(zipFile, new Step[]{Step.pd, Step.ai, Step.ac}) : Pipeline.fromZipFile(zipFile);
            zipFile.close();
        }
    }

    public Map<Integer, Map<String, List<List<Integer>>>> parse(List<String> text) {
        String[] textt = text.toArray(new String[text.size()]);
        Sentence s = Sentence.newDepsOnlySentence(textt);
        System.out.println("Start parsing... ");
        this.srl.parseSentence(s);
        System.out.println("Finish!");
        return this.getResults(s);
    }

    public List<Map<Integer, Map<String, List<List<Integer>>>>> parse(String pathToFile) {
        DepsOnlyCoNLL09Reader reader = new DepsOnlyCoNLL09Reader(new File(pathToFile));
        List<Sentence> sens = reader.readAll();
        ArrayList<Map<Integer, Map<String, List<List<Integer>>>>> lst = new ArrayList<Map<Integer, Map<String, List<List<Integer>>>>>();
        System.out.println("Start parsing... ");
        for (Sentence s : sens) {
            this.srl.parseSentence(s);
            lst.add(this.getResults(s));
        }
        System.out.println("Finish!");
        return lst;
    }

    private Map<Integer, Map<String, List<List<Integer>>>> getResults(Sentence s) {
        HashMap<Integer, Map<String, List<List<Integer>>>> m = new HashMap<Integer, Map<String, List<List<Integer>>>>();
        for (Predicate pred : s.getPredicates()) {
            ArrayList<String> roles = new ArrayList<String>();
            HashMap mp = new HashMap();
            for (Word w : pred.getArgMap().keySet()) {
                if (roles.contains(pred.getArgumentTag(w))) continue;
                roles.add(pred.getArgumentTag(w));
            }
            Collections.sort(roles);
            TreeSet<Yield> yields = new TreeSet<Yield>();
            Map<Word, String> argmap = pred.getArgMap();
            for (Word arg : argmap.keySet()) {
                yields.addAll(arg.getYield(pred, argmap.get(arg), argmap.keySet()).explode());
            }
            for (String role : roles) {
                ArrayList lst = new ArrayList();
                for (Yield y : yields) {
                    if (!y.getArgLabel().equals(role)) continue;
                    ArrayList<Integer> l = new ArrayList<Integer>();
                    if (!y.isContinuous()) {
                        System.out.println("Something wrong, we have discontinous yields!");
                        continue;
                    }
                    int first = s.indexOf(y.first());
                    int end = s.indexOf(y.last());
                    for (int j = first; j <= end; ++j) {
                        l.add(j);
                    }
                    lst.add(l);
                }
                mp.put(role, lst);
            }
            m.put(s.indexOf(pred), mp);
        }
        return m;
    }

    public static void main(String[] args) throws Exception {
        MuseInterface mi = MuseInterface.getInstance("/Users/quynhdo/Documents/MUSE/SRL/models/srl.model", false);
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("1\tThe\tthe\tthe\tDT\tDT\t_\t_\t2\t2\tNMOD\tNMOD\t_\t_");
        lst.add("2\teconomy\teconomy\teconomy\tNN\tNN\t_\t_\t4\t4\tNMOD\tNMOD\t_\t_");
        lst.add("3\t's\t's\t's\tPOS\tPOS\t_\t_\t2\t2\tSUFFIX\tSUFFIX\t_\t_");
        lst.add("4\ttemperature\ttemperature\ttemperature\tNN\tNN\t_\t_\t5\t5\tSBJ\tSBJ\t_\t_");
        lst.add("5\twill\twill\twill\tMD\tMD\t_\t_\t0\t0\tROOT\tROOT\t_\t_");
        lst.add("6\tbe\tbe\tbe\tVB\tVB\t_\t_\t5\t5\tVC\tVC\t_\t_");
        lst.add("7\ttaken\ttake\ttake\tVBN\tVBN\t_\t_\t6\t6\tVC\tVC\t_ _");
        lst.add("8\tfrom\tfrom\tfrom\tIN\tIN\t_\t_\t7\t7\tADV\tADV\t_\t_");
        lst.add("9\tseveral\tseveral\tseveral\tDT\tDT\t_\t_\t11\t11\tNMOD\tNMOD\t_\t_");
        lst.add("10\tvantage\tvantage\tvantage\tNN\tNN\t_\t_\t11\t11\tNMOD\tNMOD\t_\t_");
        lst.add("11\tpoints\tpoint\tpoint\tNNS\tNNS\t_\t_\t8\t8\tPMOD\tPMOD\t_\t_");
        Map<Integer, Map<String, List<List<Integer>>>> tmp = mi.parse(lst);
        System.out.println(tmp.toString());
    }
}

