/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.srl.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.corpus.Yield;
import se.lth.cs.srl.io.AllCoNLL09Reader;

public class MuseConverter {
    ArrayList<String> subjects = new ArrayList();
    ArrayList<String> objects;

    public MuseConverter() {
        this.subjects.add("tuk");
        this.subjects.add("bear");
        this.subjects.add("beast");
        this.subjects.add("boy");
        this.subjects.add("dog");
        this.subjects.add("dogs");
        this.subjects.add("family");
        this.subjects.add("father");
        this.subjects.add("hunters");
        this.subjects.add("kavik");
        this.subjects.add("mother");
        this.subjects.add("nanuk");
        this.subjects.add("seal");
        this.subjects.add("sister");
        this.subjects.add("son");
        this.subjects.add("tuk");
        this.subjects.add("uncle");
        this.subjects.add("uncle kavik");
    }

    public static void convertSRLToActionMapper(String srl_in, String mapper_out, String type) throws IOException {
        File f = new File(srl_in);
        AllCoNLL09Reader reader = new AllCoNLL09Reader(f);
        StringBuilder sb = new StringBuilder();
        List<Sentence> sens = reader.readAll();
        for (Sentence s : sens) {
            sb.append("\n---SENTENCE---\n");
            sb.append(s.toStringTxt());
            sb.append("\n");
            for (Predicate pred : s.getPredicates()) {
                if (type.equals("V") && !pred.getPOS().startsWith("V") || type.equals("N") && !pred.getPOS().startsWith("N") || type.equals("NV") && !pred.getPOS().startsWith("N") && !pred.getPOS().startsWith("V")) continue;
                sb.append("---FRAME---\n");
                sb.append("pred: " + pred.getForm() + "\n");
                ArrayList<String> roles = new ArrayList<String>();
                for (Word w : pred.getArgMap().keySet()) {
                    if (roles.contains(pred.getArgumentTag(w))) continue;
                    roles.add(pred.getArgumentTag(w));
                }
                Collections.sort(roles);
                TreeSet<Yield> yields = new TreeSet<Yield>();
                Map<Word, String> argmap = pred.getArgMap();
                for (Word arg : argmap.keySet()) {
                    yields.addAll(arg.getYield(pred, argmap.get(arg), argmap.keySet()).explode());
                }
                for (String role : roles) {
                    sb.append(role + ": ");
                    for (Yield y : yields) {
                        if (!y.getArgLabel().equals(role)) continue;
                        if (!y.isContinuous()) {
                            System.out.println("Something wrong, we have discontinous yields!");
                            continue;
                        }
                        sb.append(MuseConverter.YieldToString(y, s) + " ");
                    }
                    sb.append("\n");
                }
            }
        }
        FileWriter fw = new FileWriter(new File(mapper_out));
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(sb.toString());
        bw.close();
    }

    private static String YieldToString(Yield y, Sentence s) {
        String tmp = "";
        int first = s.indexOf(y.first());
        int end = s.indexOf(y.last());
        for (int i = first; i <= end; ++i) {
            tmp = tmp + ((Word)s.get(i)).getForm();
            if (i >= end) continue;
            tmp = tmp + " ";
        }
        return tmp;
    }

    public static void main(String[] args) throws IOException {
        String input_folder = args[0];
        String output_folder = args[1];
        File f = new File(input_folder);
        if (f.isDirectory()) {
            File[] childs;
            for (File child : childs = f.listFiles()) {
                String srl_in = child.getAbsolutePath();
                String mapper_out = output_folder + "/" + child.getName() + ".out.txt";
                MuseConverter.convertSRLToActionMapper(srl_in, mapper_out, "NV");
            }
        } else {
            MuseConverter.convertSRLToActionMapper(input_folder, output_folder, "NV");
        }
    }
}

