/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.srl.group;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.io.FileUtils;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.io.AllCoNLL09Reader;

public class DataExtracter {
    Hashtable<String, Hashtable<String, String>> predicates = new Hashtable();
    List<Sentence> sens;

    public DataExtracter(String data) {
        AllCoNLL09Reader reader = new AllCoNLL09Reader(new File(data));
        this.sens = reader.readAll();
    }

    public void setSource(String source_file) {
        List arr;
        this.predicates.clear();
        try {
            arr = FileUtils.readLines((File)new File(source_file));
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read source file:" + source_file, ex);
        }
        for (String str : arr) {
            String[] temps = str.split("\\s+");
            this.predicates.put(temps[0], new Hashtable());
        }
    }

    public ArrayList<Predicate> getAllSenses(String p) {
        ArrayList<Predicate> arr = new ArrayList<Predicate>();
        String[] tmps1 = p.split("\\.");
        for (Sentence se : this.sens) {
            for (Predicate pred : se.getPredicates()) {
                String[] tmps = pred.getSense().split("\\.");
                if (!tmps1[0].toLowerCase().equals(tmps[0].toLowerCase())) continue;
                arr.add(pred);
            }
        }
        return arr;
    }

    public ArrayList<Predicate> getExactlySense(String p) {
        ArrayList<Predicate> arr = new ArrayList<Predicate>();
        for (Sentence se : this.sens) {
            for (Predicate pred : se.getPredicates()) {
                if (!pred.getSense().equalsIgnoreCase(p)) continue;
                arr.add(pred);
            }
        }
        return arr;
    }

    public static void main(String[] args) {
        String trainingfile = "/Users/quynhdo/Documents/WORKING/MYWORK/EACL/CoNLL2009-ST-English/CoNLL2009-ST-English-train.txt";
        String predicatefile = "/Users/quynhdo/Downloads/seeing.txt";
        DataExtracter extracter = new DataExtracter(trainingfile);
        extracter.setSource(predicatefile);
        for (String pred : extracter.predicates.keySet()) {
            ArrayList<Predicate> allsense = extracter.getAllSenses(pred);
            ArrayList<Predicate> sense = extracter.getExactlySense(pred);
            System.out.print(pred + ": ");
            System.out.print(allsense.size() + ":");
            System.out.println(sense.size());
        }
    }
}

